import { isExternal, validURL, validLowerCase, validUpperCase, validAlphabets, validUserName, validEmail, float83, float96, float23 } from '@/utils/validate.js'
describe('Utils:validate', () => {
  it('validIsExternal', () => {
    expect(isExternal('https://www.google.com')).toBe(true)
    expect(isExternal('htt://www.google.com')).toBe(false)
  })
  it('validURL', () => {
    expect(validURL('https://github.com/PanJiaChen/vue-element-admin')).toBe(true)
    expect(validURL('http://github.com/PanJiaChen/vue-element-admin')).toBe(true)
    expect(validURL('github.com/PanJiaChen/vue-element-admin')).toBe(false)
  })
  it('validLowerCase', () => {
    expect(validLowerCase('abc')).toBe(true)
    expect(validLowerCase('Abc')).toBe(false)
    expect(validLowerCase('123abc')).toBe(false)
  })
  it('validUpperCase', () => {
    expect(validUpperCase('ABC')).toBe(true)
    expect(validUpperCase('Abc')).toBe(false)
    expect(validUpperCase('123ABC')).toBe(false)
  })
  it('validAlphabets', () => {
    expect(validAlphabets('ABC')).toBe(true)
    expect(validAlphabets('Abc')).toBe(true)
    expect(validAlphabets('123aBC')).toBe(false)
  })
  it('validUserName', () => {
    expect(validUserName('abc')).toBe(true)
    expect(validUserName('Abc')).toBe(true)
    expect(validUserName('abc123')).toBe(true)
    expect(validUserName('Abc123')).toBe(true)
    expect(validUserName('张')).toBe(false)
    expect(validUserName('。')).toBe(false)
    expect(validUserName('abc.123')).toBe(false)
  })
  it('validUserEmail', () => {
    expect(validEmail('abc@123.com')).toBe(true)
    expect(validEmail('abc@123')).toBe(false)
  })
  describe('validFloat83', ()=> {
    it('Input correctly', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float83(null, 12345678.123,callback);
    });
    it('Integer correct Decimal error', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float83(null, 12345678.1234,callback);
    });
    it('Integer error Decimal correct', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float83(null, 123456789.123,callback);
    });
    it('Integer error Decimal error', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float83(null, 123456789.1234,callback);
    });
    it('Input void', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float83(null, '',callback);
    });
    it('Input null', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float83(null, null,callback);
    });
    it('Input string', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float83(null, 'abc',callback);
    });
  })
  describe('validFloat96', ()=> {
    it('Input correctly', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float96(null, 123456789.123456,callback);
    });
    it('Integer correct Decimal error', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float96(null, 123456789.1234567,callback);
    });
    it('Integer error Decimal correct', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float96(null, 1234567890.123456,callback);
    });
    it('Integer error Decimal error', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float96(null, 1234567890.1234567,callback);
    });
    it('Input void', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float96(null, '',callback);
    });
    it('Input null', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float96(null, null,callback);
    });
    it('Input string', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float96(null, 'abc',callback);
    });
  })
  describe('validFloat23', ()=> {
    it('Input correctly', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float23(null, 12.123,callback);
    });
    it('Integer correct Decimal error', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float23(null, 12.1234,callback);
    });
    it('Integer error Decimal correct', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float23(null, 123.123,callback);
    });
    it('Integer error Decimal error', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float23(null, 123.1234,callback);
    });
    it('Input void', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float23(null, '',callback);
    });
    it('Input null', done => {
      function callback(data) {
        expect(data).toBeUndefined()
        done();
      }
      float23(null, null,callback);
    });
    it('Input string', done => {
      function callback(data) {
        const err = new Error('请正确输入')
        expect(data).toMatchObject(err);
        done();
      }
      float23(null, 'abc',callback);
    });
  })
})
