import Common from '@/layout/common/index'

const router = {
  menuId: 'SystemMgr',
  path: '/system-management',
  name: '系统管理',
  component: Common,
  redirect: '/system-management/sys-management',
  meta: { title: '系统管理', icon: 'menu-1' },
  children: [
    {
      menuId: 'SysMgr',
      path: 'sys-management',
      name: '系统列表',
      component: () => import('@/views/system-management/sys-management'),
      meta: { title: '系统列表', icon: 'setting' }
    },
    {
      menuId: 'MenuMgr',
      path: 'menu-management',
      name: '菜单管理',
      component: () => import('@/views/system-management/menu-management'),
      meta: { title: '菜单管理', icon: 'menu-1' }
    },
    {
      menuId: 'OrgMgr',
      path: 'organization-management',
      name: '组织管理',
      component: () => import('@/views/system-management/organization-management'),
      meta: { title: '组织管理', icon: 'organization' }
    },
    {
      menuId: 'UserMgr',
      path: 'user-management',
      name: '人员管理',
      component: () => import('@/views/system-management/user-management'),
      meta: { title: '人员管理', icon: 'user' }
    },
    {
      menuId: 'RoleMgr',
      path: 'role-management',
      name: 'role-management',
      component: () => import('@/views/system-management/role-management'),
      meta: { title: '角色管理', icon: 'role' }
    },
    {
      menuId: 'AuthMgr',
      path: 'auth-management',
      name: 'auth-management',
      component: () => import('@/views/system-management/auth-management'),
      meta: { title: '权限管理', icon: 'auth' }
    },
    {
      menuId: 'ApiAuthorityMgr',
      path: 'api-authority',
      name: 'api-authority',
      component: () => import('@/views/system-management/api-authority'),
      meta: { title: 'API接口管理', icon: 'bug' }
    }
  ]
}
export default router
