import Vue from 'vue'
import Router from 'vue-router'
import settings from '@/settings'

Vue.use(Router)

/* Layout */
import Common from '@/layout/common/index'

/**
 * Note: sub-menu only appear when route children.length >= 1
 * Detail see: https://panjiachen.github.io/vue-element-admin-site/guide/essentials/router-and-nav.html
 *
 * hidden: true                   if set true, item will not show in the sidebar(default is false)
 * alwaysShow: true               if set true, will always show the root menu
 *                                if not set alwaysShow, when item has more than one children route,
 *                                it will becomes nested mode, otherwise not show the root menu
 * redirect: noRedirect           if set noRedirect will no redirect in the breadcrumb
 * name:'router-name'             the name is used by <keep-alive> (must set!!!)
 * meta : {
    roles: ['admin','editor']    control the page roles (you can set multiple roles)
    title: 'title'               the name show in sidebar and breadcrumb (recommend set)
    icon: 'svg-name'             the icon show in the sidebar
    noCache: true                if set true, the page will no be cached(default is false)
    affix: true                  if set true, the tag will affix in the tags-view
    breadcrumb: false            if set false, the item will hidden in breadcrumb(default is true)
    activeMenu: '/example/list'  if set path, the sidebar will highlight the path you set
  }
 */

/**
 * constantRoutes
 * a base page that does not have permission requirements
 * all roles can be accessed
 */
const routes = [
  {
    path: '/redirect',
    component: Common,
    hidden: true,
    children: [
      {
        path: '/redirect/:path*',
        component: () => import('@/views/redirect/index')
      }
    ]
  },
  {
    path: '/login',
    component: () => import('@/views/login/index'),
    hidden: true
  },
  {
    path: '/auth-redirect',
    component: () => import('@/views/login/auth-redirect'),
    hidden: true
  },
  {
    path: '/404',
    component: () => import('@/views/error-page/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error-page/401'),
    hidden: true
  },

  {
    path: '/',
    component: Common,
    redirect: '/data-management/data-model'
  }
]
if (settings.overview) {
  routes.pop()
  routes.push({
    path: '/',
    component: Common,
    redirect: '/overview',
    children: [
      {
        path: 'Overview',
        name: 'Overview',
        component: () => import('@/views/overview/index'),
        meta: { title: '首页', icon: 'home', affix: true }
      }
    ]
  })
}
export const constantRoutes = routes

/**
 * asyncRoutes
 * the routes that need to be dynamically loaded based on user roles
 */
// 系统管理
import systemManagement from './modules/systemManagement'
// 租户管理
import tenantManagement from './modules/tenantManagement'
// 数据管理
import dataManagement from './modules/dataManagement'
// 数据可视
import dataVisible from './modules/dataVisibleManagement'
// 设备管理
import equipmentManagement from './modules/equipmentManagement'
// 告警管理
import deviceAlarm from './modules/deviceAlarm'

export const asyncRoutes = [
  dataVisible,
  dataManagement,
  equipmentManagement,
  deviceAlarm,
  systemManagement,
  tenantManagement,
  // 404 page must be placed at the end !!!
  { path: '*', redirect: '/404', hidden: true }
]

const createRouter = () => new Router({
  // mode: 'history', // require service support
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRoutes
})

const router = createRouter()

// Detail see: https://github.com/vuejs/vue-router/issues/1234#issuecomment-357941465
export function resetRouter() {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher // reset router
}

export default router
