import { mapGetters } from 'vuex'

const dictionary = {
  data() {
    return {
      goodsTypeProps: {
        value: 'code',
        label: 'name'
      }
    }
  },
  computed: {
    ...mapGetters([
      'dictionary'
    ])
  },
  methods: {
    $_dictionaryFormat(row, column, cellValue, index, prop) {
      // 3种情况
      // 用在 table-column 中，使用默认入参，4个入参
      // 用在 table-column 中，使用指定入参，5个入参
      // 当作 filter 使用，使用指定入参，2个入参
      // 处理cellValue为0时 （cellValue && true）为false的情况，
      const val = ((cellValue === 0 ? true : cellValue) && true) ? cellValue : row
      const property = prop || column.property || column
      const data = this.dictionary[property].find(v => v.code === parseInt(val))
      return data ? data.name : null
    }
  }
}

export default dictionary
