import request from '@/utils/request'
// const baseURL = process.env.VUE_APP_BASE_API
const baseURL = ''

// 获取设备类型列表-分页
export function getDeviceTypeList(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/list`,
    method: 'post',
    data
  })
}

// 增加设备类型
export function addDeviceType(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/add`,
    method: 'post',
    data
  })
}

// 编辑设备类型
export function updateDeviceType(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/edit`,
    method: 'post',
    data
  })
}

// 删除设备类型
export function deleteDeviceType(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/delete`,
    method: 'post',
    data
  })
}

// 关联数据模型
export function bindingDataModel(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/saveDataModelByDeviceTypeId`,
    method: 'post',
    data
  })
}

// 获取已关联数据模型
export function getDataModelByDeviceTypeId(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/getDataModelByDeviceTypeId`,
    method: 'post',
    data
  })
}

// 获取设备类型对应的实例数量统计
export function getDeviceTypeStatistics(data) {
  return request({
    url: `${baseURL}/iot/deviceModel/getDeviceTypeStatistics`,
    method: 'post',
    data
  })
}
