import Common from '@/layout/common/index'

const router = {
  menuId: 'TenantMgr',
  path: '/tenant-management',
  name: '租户管理',
  component: Common,
  redirect: '/tenant-management/tenant-management',
  meta: { title: '租户管理', icon: 'tenant' },
  children: [
    {
      menuId: 'TenantMgrTenant',
      path: 'tenant-management',
      name: '租户列表',
      component: () => import('@/views/tenant-management/tenant-management'),
      meta: { title: '租户列表', icon: 'tenant2' }
    },
    {
      menuId: 'TenantAuth',
      path: 'tenant-auth',
      name: '租户权限',
      component: () => import('@/views/tenant-management/auth'),
      meta: { title: '租户权限', icon: 'auth2' }
    },
    {
      menuId: 'TenantAccount',
      path: 'tenant-account',
      name: '管理员账号',
      component: () => import('@/views/tenant-management/account'),
      meta: { title: '管理员账号', icon: 'account' }
    }
  ]
}
export default router
