import Common from '@/layout/common/index'

const router = {
  menuId: 'DatasetMgr',
  path: '/dataset-management',
  name: '数据管理',
  component: Common,
  redirect: '/dataset-management/mine-dataset',
  meta: { title: '数据管理', icon: 'dataMgr' },
  alwaysShow: true,
  children: [
    {
      menuId: 'DatasetMgrMine',
      path: 'mine-dataset',
      name: '我的数据',
      component: () => import('@/views/dataset-management/mine-dataset'),
      meta: { title: '我的数据', icon: 'my-data' }
    },
    {
      menuId: 'DatasetMgrDetail',
      path: 'dataset-detail',
      name: '数据详情',
      hidden: true,
      component: () => import('@/views/dataset-management/dataset-detail'),
      meta: { title: '数据详情', icon: 'tenant' }
    },
    {
      menuId: 'DatasetMgrUpload',
      path: 'upload-dataset',
      name: '上传数据',
      hidden: true,
      component: () => import('@/views/dataset-management/upload-dataset'),
      meta: { title: '上传数据', icon: 'tenant' }
    }
  ]
}
export default router
