import Common from '@/layout/common/index'

const router = {
  menuId: 'OnlineService',
  path: '/online-service',
  name: '在线服务',
  component: Common,
  redirect: '/online-service/mine-service',
  meta: { title: '在线服务', icon: 'onlineService' },
  alwaysShow: true,
  children: [
    {
      menuId: 'OnlineServiceMine',
      path: 'mine-service',
      name: '我的服务',
      component: () => import('@/views/online-service/mine-service'),
      meta: { title: '我的服务', icon: 'my-service' }
    },
    {
      menuId: 'OnlineServiceMonitor',
      path: 'service-monitor',
      name: '服务监控',
      hidden: true,
      component: () => import('@/views/online-service/service-monitor'),
      meta: { title: '服务监控', icon: 'my-service' }
    }
  ]
}
export default router
