import Common from '@/layout/common/index'

const router = {
  menuId: 'ModelWarehouse',
  path: '/model-warehouse',
  name: '模型仓库',
  component: Common,
  redirect: '/model-warehouse/mine-model',
  meta: { title: '模型仓库', icon: 'warehouse' },
  alwaysShow: true,
  children: [
    {
      menuId: 'ModelWarehouseMine',
      path: 'mine-model',
      name: '我的模型',
      component: () => import('@/views/model-warehouse/mine-model'),
      meta: { title: '我的模型', icon: 'my-model' }
    },
    {
      menuId: 'ModelWarehouseVersion',
      path: 'model-version',
      name: '模型版本',
      hidden: true,
      component: () => import('@/views/model-warehouse/model-version'),
      meta: {
        title: '模型版本',
        icon: 'my-model',
        activeMenu: '/model-warehouse/mine-model'
      }
    },
    {
      menuId: 'ModelWarehouseDetail',
      path: 'version-detail',
      name: '版本详情',
      hidden: true,
      component: () => import('@/views/model-warehouse/version-detail'),
      meta: {
        title: '版本详情',
        icon: 'my-model',
        activeMenu: '/model-warehouse/mine-model'
      }
    }
  ]
}
export default router
