import store from '@/store'

export default {
  inserted(el, binding) {
    const { value } = binding
    const permissions = store.getters && store.getters.permissions
    const hasPermission = permissions.includes(value)
    if (!hasPermission) {
      el.classList.add('is-disabled')
      el.disabled = 'disabled'
    }
  }
}
