const data = [
  {
    id: 1,
    taskName: '设备故障诊断',
    status: 0,
    updateTime: 1593321093655
  },
  {
    id: 2,
    taskName: '个人信用贷款',
    status: 1,
    updateTime: 1593321093655
  },
  {
    id: 3,
    taskName: '物流最优路径',
    status: 2,
    updateTime: 1593321093655
  }
]
const modelDetail = {
  'nodes': [
    {
      'name': '线性回归',
      'groupName': '机器学习',
      'label': '线性回归',
      'size': [
        '170',
        '34'
      ],
      'type': 'node',
      'x': 406,
      'y': 395,
      'shape': 'customNode',
      'color': '#1890ff',
      'image': '/static/img/tezhenggongcheng.d621fe0d.svg',
      'stateImage': '',
      'inPoints': [
        [
          0,
          0.5
        ]
      ],
      'outPoints': [
        [
          1,
          0.5
        ]
      ],
      'paramType': 'g',
      'params': {
        'alpha': 0,
        'lambda': '1',
        'randomSeed': '2',
        'maxIterations': '1',
        'targetConvergenceThreshold': '1',
        'crossValidation': 1
      },
      'fieldType': 'd',
      'fields': {
        'featureId': [
          1,
          2
        ],
        'labelId': 1
      },
      'offsetX': 80,
      'offsetY': 34,
      'id': 'node1291',
      'style': {}
    },
    {
      'name': '数据集',
      'groupName': '数据集组件',
      'label': '数据集',
      'size': [
        '170',
        '34'
      ],
      'type': 'node',
      'x': 426,
      'y': 102,
      'shape': 'customNode',
      'color': '#1890ff',
      'image': '/static/img/dataset.5b96d2e4.svg',
      'stateImage': '/static/img/ok.463ab0e4.svg',
      'inPoints': [
        [
          0,
          0.5
        ]
      ],
      'outPoints': [
        [
          1,
          0.5
        ]
      ],
      'fieldType': 'a',
      'fields': {
        'datasetId': 1
      },
      'offsetX': 77,
      'offsetY': 19,
      'id': 'node1298',
      'style': {}
    },
    {
      'name': '数据类型转换',
      'groupName': '数据处理组件',
      'label': '数据类型转换',
      'size': [
        '170',
        '34'
      ],
      'type': 'node',
      'x': 415,
      'y': 183,
      'shape': 'customNode',
      'color': '#1890ff',
      'image': '/static/img/dataChange.ad51f236.svg',
      'stateImage': '',
      'inPoints': [
        [
          0,
          0.5
        ]
      ],
      'outPoints': [
        [
          1,
          0.5
        ]
      ],
      'paramType': 'c',
      'params': {
        'exportType': 1
      },
      'fieldType': 'c',
      'fields': {
        'columnId': [
          1,
          2
        ]
      },
      'offsetX': 83,
      'offsetY': 21,
      'id': 'node1305',
      'style': {}
    },
    {
      'name': '异常值处理',
      'groupName': '数据预处理',
      'label': '异常值处理',
      'size': [
        '170',
        '34'
      ],
      'type': 'node',
      'x': 411,
      'y': 289,
      'shape': 'customNode',
      'color': '#1890ff',
      'image': '/static/img/tezhenggongcheng.d621fe0d.svg',
      'stateImage': '',
      'inPoints': [
        [
          0,
          0.5
        ]
      ],
      'outPoints': [
        [
          1,
          0.5
        ]
      ],
      'paramType': 'f',
      'params': {
        'outlierType': 1,
        'fillingType': 1,
        'customValue': '1',
        'fillingValue': '1',
        'quantile': 0,
        'rule': null
      },
      'fieldType': 'c',
      'fields': {
        'columnId': [
          1
        ]
      },
      'offsetX': 97,
      'offsetY': 28,
      'id': 'node1312',
      'style': {}
    }
  ],
  'edges': [
    {
      'id': 'edge1405',
      'source': 'node1298',
      'target': 'node1305',
      'sourceId': 'node1298',
      'targetId': 'node1305',
      'start': {
        'x': 0,
        'y': 17
      },
      'end': {
        'x': 0,
        'y': -17
      },
      'shape': 'customEdge',
      'type': 'edge',
      'style': {},
      'startPoint': {
        'x': 423.62345679012344,
        'y': 119.5
      },
      'endPoint': {
        'x': 417.37654320987656,
        'y': 165.5
      }
    },
    {
      'id': 'edge1479',
      'source': 'node1305',
      'target': 'node1312',
      'sourceId': 'node1305',
      'targetId': 'node1312',
      'start': {
        'x': 0,
        'y': 17
      },
      'end': {
        'x': 0,
        'y': -17
      },
      'shape': 'customEdge',
      'type': 'edge',
      'style': {},
      'startPoint': {
        'x': 414.33962264150944,
        'y': 200.5
      },
      'endPoint': {
        'x': 411.66037735849056,
        'y': 271.5
      }
    },
    {
      'id': 'edge1569',
      'source': 'node1312',
      'target': 'node1291',
      'sourceId': 'node1312',
      'targetId': 'node1291',
      'start': {
        'x': 0,
        'y': 17
      },
      'end': {
        'x': 0,
        'y': -17
      },
      'shape': 'customEdge',
      'type': 'edge',
      'style': {},
      'startPoint': {
        'x': 410.17452830188677,
        'y': 306.5
      },
      'endPoint': {
        'x': 406.82547169811323,
        'y': 377.5
      }
    }
  ],
  'combos': [],
  'groups': []
}
export default [
  // 获取任务列表
  {
    url: '/cc/linque/getTaskList',
    type: 'post',
    response: _ => {
      return {
        code: 200,
        message: 'success',
        responseTime: 1593321093655,
        data: {
          pageNum: 1,
          pageSize: 10,
          totalSize: data.length,
          records: data
        }
      }
    }
  },
  // 创建实验
  {
    url: '/cc/linque/createTask',
    type: 'post',
    response: (req, res) => {
      const { taskName } = req.body
      const date = new Date()
      const task = {
        taskName,
        id: data.length + 1,
        status: 2,
        updateTime: date.getTime()
      }
      data.push(task)
      return {
        code: 200,
        message: 'success',
        responseTime: 1593321093655,
        data: {}
      }
    }
  },
  // 删除实验
  {
    url: '/cc/linque/deleteTask',
    type: 'post',
    response: (req, res) => {
      const { id } = req.body
      const index = data.findIndex(item => item.id === id)
      data.splice(index, 1)
      return {
        code: 200,
        message: 'success',
        responseTime: 1593321093655,
        data: {}
      }
    }
  },
  // 创建模型
  {
    url: '/cc/linque/createModel',
    type: 'post',
    response: (req, res) => {
      return {
        code: 200,
        message: 'success',
        responseTime: 1593321093655,
        data: {}
      }
    }
  },
  // 获取模型数据
  {
    url: '/cc/linque/getModelVisualization',
    type: 'post',
    response: (req, res) => {
      return {
        code: 200,
        message: 'success',
        responseTime: 1593321093655,
        data: modelDetail
      }
    }
  }
]
