import Common from '@/layout/common/index'

const router = {
  menuId: 'ModelTraining',
  path: '/model-training',
  name: '模型训练',
  component: Common,
  redirect: '/model-training/visualization',
  meta: { title: '模型训练', icon: 'model' },
  alwaysShow: true,
  children: [
    {
      menuId: 'Visualization',
      path: 'visualization',
      name: '可视化模型',
      component: () => import('@/views/model-training/visualization'),
      meta: { title: '可视化模型', icon: 'vis' }
    },
    {
      menuId: 'EditModel',
      path: 'edit-model',
      name: '编辑画布',
      hidden: true,
      component: () => import('@/views/model-training/edit-model'),
      meta: { title: '编辑画布', icon: 'vis' }
    }
  ]
}
export default router
