## 说明

本项目为 英思唯 数据中台 前端工程，简称 data-center-web

### 技术栈

- [Vue.js](https://cn.vuejs.org/)
- [Vue Router](https://router.vuejs.org/zh/)
- [Vuex](https://vuex.vuejs.org/zh/)
- [Vue-CLI 3](https://cli.vuejs.org/zh/)
- [Element-ui](https://element.eleme.cn/#/zh-CN)
- [ES6](http://es6.ruanyifeng.com/)

## 准备

### 安装 Node.js 并配置 Npm

安装 [Node.js](https://nodejs.org/zh-cn/) 后检查版本

```bash
node --version
```

npm 会随着 node 一起安装，检查版本

```bash
npm --version
```

修改 npm 为淘宝源

```bash
npm config set registry https://registry.npm.taobao.org
```

### 推荐使用 Webstorm

在设置中的 Languages& Frameworks | JavaScript | Webpack 中选用webpack.config.js 文件来配置 webpack 的全局 allies

### 必须开启 ESLint 语法检查

在设置中的 Languages& Frameworks | JavaScript | Code Quality Tools | ESLint 中选择 Automatic ESLint configuration 启用 ESLint 语法检查

## 安装

打开项目工程

```bash
cd esv-iot-web
```

安装依赖

```bash
npm i
```

## 运行

在 .env.development 文件中设置开发时 baseUrl

```bash
VUE_APP_BASE_API = 'XXXXXX'
```

### 使用后台

```bash
# 使用 baseUrl 地址
npm run dev
```
### 本地 Mock

使用 `npm run dev:mock` 开发会在本地启动一个 `mock-server` 来 mock 网络请求的返回值。
mock-server 会拦截 network 中的 request 来达到 mock 数据的效果。
需要提前在 mock 目录下设置 mock 数据。

```bash
# 使用本地 mock 接口
npm run dev:mock
```
## 构建

在 .env.production 文件中设置开发时 baseUrl

```bash
VUE_APP_BASE_API = 'XXXXXXXXX'
```

开始构建

```bash
# 为生产环境构建
npm run build:prod
```

## 更多

```bash
# 本地预览为生产环境构建文件
npm run preview

# 本地预览为生产环境构建文件+分析构建文件依赖关系
npm run preview -- --report

# 代码风格检查
npm run lint

# 代码风格检查并修正
npm run lint -- --fix
```

## 权限控制

### 动态生成侧边栏

在 router/index.js 中可以配置两种路由记录

* constantRoutes：不受权限控制
* asyncRoutes：收权限控制

在用户登录之后会请求该用户可访问的菜单列表和可允许使用的按键列表，根据返回的 menuList 与 asyncRoutes 对比生成 accessRoutes ，使用accessRoutes 生成侧边栏，达到菜单/页面权限控制的目的；

### 可访问按键列表

在页面开发时对 button 埋点关键词，通过 v-permission 自定义指令对比可允许使用的按键列表，不在表中则设置 disabled 状态，达到按键级别权限控制的目的

## 单元测试

### 前端测试框架

采用Vue 官方提供的 Vue Test Utils 单元测试实用工具库，使用Jest 测试运行器。

### 测试策略

* Vue 组件
  * 组件分支渲染逻辑
  * 事件调用和参数传递
* 基础方法、类
* Vuex actions、mutations

### 示例

* 组件：tests\unit\components
* Vuex：tests\unit\store
* 工具：tests\unit\utils
* 页面：tests\unit\views

## 端对端测试

因为本项目是采用 Vue Cli 构建的，所以选择采用官方推荐的 NightWatch 插件来执行E2E测试。

### 示例

- 用例: tests\e2e\specs\test-with-pageobject.js

  登录成功页面跳转首页用例

### 参考

[Nightwatch.js]: https://nightwatchjs.org/

## 代码风格检查

## ESLint

ESLint 是一个代码语法和风格的检查工具，本项目内置ESLint，必须开启。

开启 ESLint 之后会在本地开发时实时对js\vue\scss文件进行语法和风格检查，并且给出强烈提示。

## 图标

如果你没有在本项目 [Icon](https://github.com/PanJiaChen/vue-element-admin/tree/master/src/icons/svg) 中找到需要的图标，可以到 [iconfont.cn](http://iconfont.cn/) 上选择并生成自己的业务图标库，再进行使用。或者其它 svg 图标网站，下载 svg 并放到文件夹之中就可以了。

## 模版

平时日常工作中，做最多的就是写业务模块和组件。当每次新开一个`view`或者`component`的时候都需要手动创建一个新`.vue`，然后创建一个页面，还是有些麻烦的。

执行以下命令：

```bash
npm run new
```

按照提示选择`views` 或 `components`

按照提示输入页面名称和路径，即可在指定路径下生成文件

## 部署

在 Docker 容器中使用 Nginx 部署应用。

1. 在项目根目录处有一个 Dockerfile 文件

2. 在项目根目录处有一个 .dockerignore 文件

   防止 node_modules 和其他中间构建产物被复制到镜像中导致构建问题

3. 在项目根目录有一个 nginx.conf 文件

   在80端口上对外提供 Vue 构建后的静态文件

4. 在 Jenkins 上构建 Docker 镜像和 运行 Docker 镜像 

## 全局过滤器 Filter

在 src/filters/index.js 中管理着全局过滤器，通过 main.js 为 Vue 全局注册，全局的过滤器没加私有前缀

```javascript
// global filters
import * as filters from './filters'

// register global utility filters
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})
```

### moment

moment 时间格式化工具 

```javascript
export function momentFilter(value, formatString) {
  formatString = formatString || 'YYYY-MM-DD HH:mm:ss'
  if (value === undefined) {
    return null
  }
  return moment(value).format(formatString)
}
```

用在展示数据时把时间戳转换为带有固定格式的日期

```javascript
{{ 1587712722637 | momentFilter }}
```

除了 moment 之外还有 pluralize、timeAgo这些可以全局使用的过滤器

## 全局方法

在 main.js 中 Mixin 全局方法，全局混入的方法名加 $前缀，以便与实例内方法区分开

### $moment

在 main.js 中全局混入 $moment 时间格式化工具

```javascript
Vue.mixin({
  methods: {
    $moment(row, column, cellValue) {
      const m = moment(cellValue, 'x')
      return m.isValid() ? moment(cellValue).format('YYYY-MM-DD HH:mm:ss') : null
    }
  }
})
```

 在 table 中对 el-table-column 中的时间戳进行时间格式化使用的

```javascript
<el-table-column
  prop="createTime"
  label="运单生成时间"
  min-width="155"
  :formatter="$moment"
/>
```
