import Common from '@/layout/common/index'

const router = {
  menuId: 'DeviceMgr',
  path: '/device-management',
  name: '实例管理',
  component: Common,
  redirect: '/device-management/device-instance',
  meta: { title: '设备实例', icon: 'equipment-instance' },
  alwaysShow: true,
  children: [
    {
      menuId: 'DeviceDetail',
      path: 'device-detail',
      name: '设备详情',
      component: () => import('@/views/device-management/device-detail'),
      meta: { title: '设备详情', icon: 'equipment-model' }
    },
    {
      menuId: 'DeviceMonitoring',
      path: 'device-monitoring',
      name: '实时监控',
      component: () => import('@/views/device-management/device-monitoring'),
      meta: { title: '实时监控', icon: 'dashboard' }
    },
    {
      menuId: 'HistoryData',
      path: 'history-data',
      name: '历史数据',
      component: () => import('@/views/device-management/history-data'),
      meta: { title: '历史数据', icon: 'query-history' }
    }
  ]
}
export default router
