import Vue from 'vue'
import moment from 'moment'
import VueClipboard from 'vue-clipboard2'
import Cookies from 'js-cookie'

import 'normalize.css/normalize.css' // a modern alternative to CSS resets

import Element from 'element-ui'
import './styles/element-variables.scss'

import '@/styles/index.scss' // global css

import App from './App'
import store from './store'
import router from './router'
import permission from '@/directive/permission/permission'

// import './icons' // icon
import '@/icons' // api: http://www.iconfont.cn/
import './permission' // permission control
import 'core-js/stable'
import 'regenerator-runtime/runtime'
import * as filters from './filters' // global filters

// components
import descriptions from '@/components/Descriptions'
import descriptionsItem from '@/components/DescriptionsItem'
import EsvDialog from '@/components/ESVDialog'

Vue.use(Element, {
  size: Cookies.get('size') || 'medium' // set element-ui default size
})
Vue.use(VueClipboard)

// import { mockXHR } from '../mock'
// if (process.env.NODE_ENV === 'production') {
//   mockXHR()
// }

// 全局注册 v-permission 按键权限指令
Vue.directive('permission', permission)

// 全局混入 moment 时间格式化工具,用在table里
Vue.mixin({
  methods: {
    $moment(row, column, cellValue, index, format) {
      const val = cellValue || row
      const m = moment(val, 'x')
      const formatText = cellValue ? (format || 'YYYY-MM-DD HH:mm:ss') : column
      return m.isValid() ? moment(val).format(formatText) : null
    }
  }
})
// register global utility filters
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})

// register global components
Vue.component('descriptions', descriptions)
Vue.component('descriptions-item', descriptionsItem)
Vue.component('esv-dialog', EsvDialog)

Vue.config.productionTip = false

new Vue({
  el: '#app',
  router,
  store,
  render: h => h(App)
})
