import request from '@/utils/request'
// const baseURL = process.env.VUE_APP_BASE_API
const baseURL = ''

// 组织树列表
export function listTree(params) {
  return request({
    url: `${baseURL}/cc/department/listTree`,
    method: 'get',
    params: params
  })
}

// 新增组织
export function save(data) {
  return request({
    url: `${baseURL}/cc/department/add`,
    method: 'post',
    data
  })
}

// 删除组织
export function deleteRow(data) {
  return request({
    url: `${baseURL}/cc/department/delete`,
    method: 'post',
    data
  })
}

// 组织详情
export function info(params) {
  return request({
    url: `${baseURL}/cc/department/info`,
    method: 'get',
    params: params
  })
}

// 修改组织信息
export function update(data) {
  return request({
    url: `${baseURL}/cc/department/update`,
    method: 'post',
    data
  })
}

// 查询可修改上级组织
export function chooseList(params) {
  return request({
    url: `${baseURL}/cc/department/chooseList`,
    method: 'get',
    params: params
  })
}
