import Mock from 'mockjs'
import { param2Obj } from '../src/utils'

import login from './login/login'
import file from './components/file'
import baseService from './components/basic-services'
import authManagement from './system-management/auth-management'
import menuManagement from './system-management/menu-management'
import systemManagement from './system-management/system-management'
import organizationManagement from './system-management/organization-management'
import userManagement from './system-management/user-management'
import roleManagement from './system-management/role-management'
import tenantManagement from './tenant-management/tenant-management'
import tenantAuth from './tenant-management/tenant-auth'
import tenantAccount from './tenant-management/tenant-account'
import mineDataset from './dataset-management/mine-dateset'
import overview from './overview/overview'

const mocks = [
  ...login,
  ...file,
  ...baseService,
  ...authManagement,
  ...menuManagement,
  ...systemManagement,
  ...organizationManagement,
  ...userManagement,
  ...roleManagement,
  ...tenantManagement,
  ...tenantAuth,
  ...tenantAccount,
  ...mineDataset,
  ...overview
]

// for front mock
// please use it cautiously, it will redefine XMLHttpRequest,
// which will cause many of your third-party libraries to be invalidated(like progress event).
export function mockXHR() {
  // mock patch
  // https://github.com/nuysoft/Mock/issues/300
  Mock.XHR.prototype.proxy_send = Mock.XHR.prototype.send
  Mock.XHR.prototype.send = function() {
    if (this.custom.xhr) {
      this.custom.xhr.withCredentials = this.withCredentials || false

      if (this.responseType) {
        this.custom.xhr.responseType = this.responseType
      }
    }
    this.proxy_send(...arguments)
  }

  function XHR2ExpressReqWrap(respond) {
    return function(options) {
      let result = null
      if (respond instanceof Function) {
        const { body, type, url } = options
        // https://expressjs.com/en/4x/api.html#req
        result = respond({
          method: type,
          body: JSON.parse(body),
          query: param2Obj(url)
        })
      } else {
        result = respond
      }
      return Mock.mock(result)
    }
  }

  for (const i of mocks) {
    Mock.mock(new RegExp(i.url), i.type || 'get', XHR2ExpressReqWrap(i.response))
  }
}

// for mock server
const responseFake = (url, type, respond) => {
  return {
    url: new RegExp(`${process.env.VUE_APP_BASE_API}${url}`),
    type: type || 'get',
    response(req, res) {
      res.json(Mock.mock(respond instanceof Function ? respond(req, res) : respond))
    }
  }
}

export default mocks.map(route => {
  return responseFake(route.url, route.type, route.response)
})
