const state = {
  tooltipPosition: {
    left: 0,
    top: 0
  },
  tooltipVisible: false,
  tooltipInfo: {
    name: null,
    groupName: null
  }
}

const mutations = {
  SET_POSITION: (state, position) => {
    const { top, left } = position
    state.tooltipPosition = {
      top: `${top}px`,
      left: `${left}px`
    }
  },
  SET_VISIBLE: (state, visible) => {
    state.tooltipVisible = visible
  },
  SET_INFO: (state, info) => {
    state.tooltipInfo = info
  }
}

const actions = {
  setPosition({ commit }, position) {
    commit('SET_POSITION', position)
  },
  setVisible({ commit }, visible) {
    commit('SET_VISIBLE', visible)
  },
  setInfo({ commit }, info) {
    commit('SET_INFO', info)
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
