import Common from '@/layout/common/index'

const router = {
  menuId: 'EquipmentMgr',
  path: '/equipment-management',
  name: '设备管理',
  component: Common,
  redirect: '/equipment-management/equipment-model',
  meta: { title: '设备管理', icon: 'equipment' },
  alwaysShow: true,
  children: [
    {
      menuId: 'EquipmentModel',
      path: 'equipment-model',
      name: '设备类型',
      component: () => import('@/views/equipment-management/equipment-model'),
      meta: { title: '设备类型', icon: 'equipment-model' }
    },
    {
      menuId: 'EquipmentInstance',
      path: 'equipment-instance',
      name: '设备实例',
      component: () => import('@/views/equipment-management/equipment-instance'),
      meta: { title: '设备实例', icon: 'equipment-instance' }
    },
    {
      menuId: 'DeviceInstance',
      path: 'device-instance',
      name: '设备实例',
      component: () => import('@/views/equipment-management/device-instance'),
      meta: { title: '设备实例', icon: 'equipment-instance' }
    }
  ]
}
export default router
