import request from '@/utils/request'
// const baseURL = process.env.VUE_APP_BASE_API
const baseURL = ''

// 获取租户列表
export function getTenantList(params) {
  return request({
    url: `${baseURL}/cc/tenant/list`,
    method: 'get',
    params: params
  })
}

// 获取租户列表-不分页
export function getAllTenantList(params) {
  return request({
    url: `${baseURL}/cc/tenant/all`,
    method: 'get',
    params: params
  })
}

// 增加租户
export function addTenant(data) {
  return request({
    url: `${baseURL}/cc/tenant/add`,
    method: 'post',
    data
  })
}

// 更新租户
export function updateTenant(data) {
  return request({
    url: `${baseURL}/cc/tenant/update`,
    method: 'post',
    data
  })
}

// 删除租户
export function deleteTenant(data) {
  return request({
    url: `${baseURL}/cc/tenant/delete`,
    method: 'post',
    data
  })
}
