import Common from '@/layout/common/index'

const router = {
  menuId: 'DataVisible',
  path: '/data-visible',
  name: '数据可视',
  component: Common,
  redirect: '/data-visible/dashboard',
  meta: { title: '数据可视', icon: 'data-visible' },
  alwaysShow: true,
  children: [
    {
      menuId: 'DashBoard',
      path: 'dashboard',
      name: '仪表盘',
      component: () => import('@/views/data-visible/dashboard'),
      meta: { title: '仪表盘', icon: 'dashboard' }
    },
    {
      menuId: 'QueryHistory',
      path: 'query-history',
      name: '历史查询',
      component: () => import('@/views/data-visible/query-history'),
      meta: { title: '历史查询', icon: 'query-history' }
    },
    {
      menuId: 'ImageIdentification',
      path: 'image-identification',
      name: '图像识别',
      component: () => import('@/views/data-visible/image-identification'),
      meta: { title: '图像识别', icon: 'image-identification' }
    }
  ]
}
export default router
