package com.esv.freight.notice.module.msg.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.notice.common.exception.EException;
import com.esv.freight.notice.common.response.EResponse;
import com.esv.freight.notice.module.msg.form.DevicePushForm;
import com.esv.freight.notice.module.msg.pojo.JPushResult;
import com.esv.freight.notice.module.msg.service.PushService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.module.msg.controller.PushController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/08 17:34
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/message")
public class PushController {

    private PushService pushService;

    @Autowired
    public PushController(PushService pushService) {
        this.pushService = pushService;
    }

    /**
     * description 给指定设备推送消息
     * param [form]
     * return com.esv.freight.notice.common.response.EResponse
     * author HuangChaobin
     * createTime 2020/06/09 11:27
     **/
    @PostMapping("/push2Device")
    public EResponse push2Device(@RequestBody @Validated DevicePushForm form) throws EException {
        JPushResult pushResult = pushService.push2Device(form);
        if (pushResult.getResult()) {
            JSONObject data = new JSONObject();
            data.put("msgId", pushResult.getMsgId());
            return EResponse.ok(data);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("[").append(pushResult.getCode()).append("]").append(pushResult.getMessage());
            return EResponse.error(1001, sb.toString());
        }
    }
}
