package com.esv.freight.notice.module.msg.form;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.module.msg.form.DevicePushForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/08 17:29
 * @version:1.0
 */
@Data
public class DevicePushForm {

    /**
     * APP类型：1-货主、2-司机
     */
    @Range(min = 1, max = 2, message = "参数appType不合法")
    @NotNull(message = "参数appType不能为空")
    private Integer appType;

    /**
     * 设备类型：1-android、2-ios
     */
    @Range(min = 1, max = 2, message = "参数deviceType不合法")
    @NotNull(message = "参数deviceType不能为空")
    private Integer deviceType;

    /**
     * 帐号
     */
    @Length(max = 64, message = "第三方消息推送中心注册的设备ID")
    @NotEmpty(message = "参数registrationId不能为空")
    private String registrationId;

    /**
     * Json格式的消息内容
     */
    @NotNull(message = "参数message不能为空")
    private JSONObject message;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
