package com.esv.freight.notice.common.util;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @description:
 * @project: notice-service
 * @name: com.esv.freight.notice.common.util.SmsCaptchaUtilsTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 16:59
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class SmsCaptchaUtilsTest {

    @Before
    public void before() {
        log.info("=================================== Test Start ===================================");
    }

    @After
    public void after() {
        log.info("=================================== Test End ===================================");
    }

    @Test
    public void test() {
        log.info(new JSONObject().getString("abc"));
        log.info(String.valueOf(StringUtils.isBlank(new JSONObject().getString("abc"))));
        log.info(String.valueOf(StringUtils.isBlank(null)));
        log.info(String.valueOf(StringUtils.isBlank("")));
        log.info(String.valueOf(StringUtils.isBlank(" ")));
        log.info(String.valueOf(StringUtils.isBlank("abc")));
    }

    /**
     * 获取默认长度的短信验证码
     **/
    @Test
    public void getCaptcha_default_length_test() {
        String smsCaptcha = SmsCaptchaUtils.getCaptcha();
        log.info("短信验证码：{}", smsCaptcha);
        Assert.assertTrue(SmsCaptchaUtils.DEFAULT_SIZE == smsCaptcha.length());
    }

    /**
     * 获取指定长度的短信验证码
     **/
    @Test
    public void getCaptcha_define_length_test() {
        int defineLength = 4;
        String smsCaptcha = SmsCaptchaUtils.getCaptcha(defineLength);
        log.info("短信验证码：{}", smsCaptcha);
        Assert.assertTrue(defineLength == smsCaptcha.length());
    }

}
