package com.esv.freight.notice.module.msg.service.impl;

import com.esv.freight.notice.common.util.ThrowableUtils;
import com.esv.freight.notice.module.msg.form.DevicePushForm;
import com.esv.freight.notice.module.msg.pojo.JPushObjectInfo;
import com.esv.freight.notice.module.msg.pojo.JPushResult;
import com.esv.freight.notice.module.msg.service.JPushService;
import com.esv.freight.notice.module.msg.service.NoticePushHistoryService;
import com.esv.freight.notice.module.msg.service.PushService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.module.msg.service.impl.PushServiceImpl
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/08 10:53
 * @version:1.0
 */
@Service("pushService")
@Slf4j
public class PushServiceImpl implements PushService {

    private JPushService jPushService;
    private NoticePushHistoryService noticePushHistoryService;

    @Autowired
    public PushServiceImpl(JPushService jPushService, NoticePushHistoryService noticePushHistoryService) {
        this.jPushService = jPushService;
        this.noticePushHistoryService = noticePushHistoryService;
    }

    @Override
    public JPushResult push2Device(DevicePushForm form) {
        // 1:获取推送目标信息
        JPushObjectInfo jPushObjectInfo = jPushService.getPushObjectInfo(form);

        // 2:推送消息
        JPushResult jPushResult = jPushService.pushMessage(jPushObjectInfo);

        // 3:推送成功，保存记录
        if (jPushResult.getResult()) {
            try {
                noticePushHistoryService.savePushResult(jPushObjectInfo, jPushResult);
            } catch (Exception e) {
                log.error("消息推送成功，保存消息记录失败：{}. {}", e.getMessage(), ThrowableUtils.toString(e));
            }
        }

        return jPushResult;
    }
}
