package com.esv.freight.notice.module.sms.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @description: 短信验证码类型枚举
 * @project: freight-file-service
 * @name: com.esv.freight.notice.module.sms.em.CaptchaEnum
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 11:20
 * @version:1.0
 */
public enum CaptchaEnum {

    UNDEFINED("undefined", "未定义"),
    LOGIN("login", "登录"),
    RESET_PWD("reset_pwd", "重置密码"),
    UPDATE_PWD("update_pwd", "修改密码");

    private String type;
    private String name;

    CaptchaEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public static CaptchaEnum getEnumByType(String type) {
        if (StringUtils.isBlank(type)){
            return CaptchaEnum.UNDEFINED;
        }
        for (CaptchaEnum em : CaptchaEnum.values()) {
            if (em.type.equalsIgnoreCase(type)) {
                return em;
            }
        }
        return CaptchaEnum.UNDEFINED;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
