package com.esv.freight.notice.module.sms.controller;

import com.esv.freight.notice.common.exception.EException;
import com.esv.freight.notice.common.response.ECode;
import com.esv.freight.notice.common.response.EResponse;
import com.esv.freight.notice.module.sms.em.CaptchaEnum;
import com.esv.freight.notice.module.sms.form.CaptchaForm;
import com.esv.freight.notice.module.sms.service.SmsCaptchaService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static java.util.regex.Pattern.compile;

/**
 * @description:
 * @project: notice-service
 * @name: com.esv.freight.notice.module.sms.controller.SmsCaptchaController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 18:07
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/sms/captcha")
public class SmsCaptchaController {

    private SmsCaptchaService smsCaptchaService;

    @Autowired
    public SmsCaptchaController(SmsCaptchaService smsCaptchaService) {
        this.smsCaptchaService = smsCaptchaService;
    }

    /**
     * description 发送短信验证码
     * param [form]
     * return com.esv.freight.notice.common.response.EResponse
     * author Administrator
     * createTime 2020/04/15 18:21
     **/
    @PostMapping("/send")
    public EResponse sendSmsCaptcha(@RequestBody @Validated CaptchaForm form) throws EException {
        // 校验参数
        CaptchaEnum captchaEnum = CaptchaEnum.getEnumByType(form.getType());
        if (CaptchaEnum.UNDEFINED == captchaEnum) {
            return EResponse.error(ECode.PARAM_ERROR.code(), "type类型不合法");
        }
        if (!this.isValidMobile(form.getPhone())) {
            return EResponse.error(1001, "无效的手机号");
        }

        smsCaptchaService.sendSmsCaptcha(form);

        return EResponse.ok();
    }

    /**
     * description 校验短信验证码
     * param [form]
     * return com.esv.freight.notice.common.response.EResponse
     * author Administrator
     * createTime 2020/04/16 18:10
     **/
    @PostMapping("/check")
    public EResponse checkSmsCaptcha(@RequestBody @Validated CaptchaForm form) throws EException {
        // 校验参数
        CaptchaEnum captchaEnum = CaptchaEnum.getEnumByType(form.getType());
        if (CaptchaEnum.UNDEFINED == captchaEnum) {
            return EResponse.error(ECode.PARAM_ERROR.code(), "type类型不合法");
        }
        if (!this.isValidMobile(form.getPhone())) {
            return EResponse.error(1001, "无效的手机号");
        }
        if (StringUtils.isBlank(form.getCaptcha())) {
            return EResponse.error(ECode.PARAM_ERROR.code(), "验证码不能为空");
        }

        smsCaptchaService.checkSmsCaptcha(form);

        return EResponse.ok();
    }

    /**
     * 正则验证手机号码
     **/
    private boolean isValidMobile(String phone) {
        Pattern p = compile("^[1][0-9]{10}$");
        Matcher m = p.matcher(phone);
        return m.matches();
    }
}
