package com.esv.freight.notice.module.msg.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.notice.module.msg.dao.NoticePushHistoryDao;
import com.esv.freight.notice.module.msg.entity.NoticePushHistoryEntity;
import com.esv.freight.notice.module.msg.pojo.JPushObjectInfo;
import com.esv.freight.notice.module.msg.pojo.JPushResult;
import com.esv.freight.notice.module.msg.service.NoticePushHistoryService;
import org.springframework.stereotype.Service;


@Service("noticePushHistoryService")
public class NoticePushHistoryServiceImpl extends ServiceImpl<NoticePushHistoryDao, NoticePushHistoryEntity> implements NoticePushHistoryService {

    @Override
    public Integer savePushResult(JPushObjectInfo jPushObjectInfo, JPushResult jPushResult) {
        NoticePushHistoryEntity entity = new NoticePushHistoryEntity();
        entity.setDeviceType(jPushObjectInfo.getDeviceType());
        entity.setRegistrationId(jPushObjectInfo.getRegistrationId());
        entity.setMsgId(jPushResult.getMsgId());
        entity.setSendNo(jPushResult.getSendNO());
        entity.setPushContent(jPushResult.getPushContent().toJSONString());

        return this.baseMapper.insert(entity);
    }
}