package com.esv.freight.notice.module.msg.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.notice.BaseTestController;
import com.esv.freight.notice.common.response.ECode;
import com.esv.freight.notice.module.msg.form.DevicePushForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.module.msg.controller.PushControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/09 11:27
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class PushControllerTest extends BaseTestController {

    /**
     * 给指定设备推送消息
     **/
    @Test
    public void a1_push2Device_success_test() throws Exception {
        String url = "/message/push2Device";

        // 构造数据
        DevicePushForm form = new DevicePushForm();
        form.setAppType(1); // APP类型：1-货主、2-司机
        form.setDeviceType(1); // 设备类型：1-android、2-ios
        form.setRegistrationId("18071adc038dfcf8ab0");

        // 设置自定义消息[message]
        JSONObject message = new JSONObject();
        message.put("msg_content", "这是一条测试消息-" + System.currentTimeMillis());
        message.put("title", "测试消息标题-" + System.currentTimeMillis());
        message.put("content_type", "text");
        JSONObject extras = new JSONObject();
        extras.put("messageType", 0);
        extras.put("data", new JSONObject());
        message.put("extras", extras);
        form.setMessage(message);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("msgId"));
    }
}
