package com.esv.freight.notice.module.msg.pojo;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 极光推送结果Pojo
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.module.msg.pojo.JPushResult
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/09 10:51
 * @version:1.0
 */
@Data
public class JPushResult {

    /**
     * 推送结果：true-成功、false-失败
     **/
    private Boolean result;

    /**
     * 推送失败：错误码
     **/
    private Integer code;

    /**
     * 推送失败：错误信息
     **/
    private String message;

    /**
     * 推送成功序列号
     **/
    private Integer sendNO;

    /**
     * 推送成功消息ID
     **/
    private String msgId;

    /**
     * 推送内容
     **/
    private JSONObject pushContent;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
