package com.esv.freight.notice.common.util;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.notice.common.constants.CommonConstants;
import com.esv.freight.notice.common.exception.EException;
import lombok.extern.slf4j.Slf4j;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.common.util.FeignUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/08 11:32
 * @version:1.0
 */
@Slf4j
public class FeignUtils {

    /**
     * description 获取Feign调用结果数据
     * param [resultJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/04/17 18:12
     **/
    public static JSONObject getFeignResultData(JSONObject resultJson) throws EException {
        String result = resultJson.toJSONString();
        if (CommonConstants.LOG_MAX_LENGTH < result.length()) {
            result = result.substring(0, CommonConstants.LOG_CUT_LENGTH) + "……";
        }
        log.info(result);
        if (CommonConstants.FEIGN_RESULT_SUCCESS == resultJson.getIntValue(CommonConstants.FEIGN_RESULT_CODE)) {
            return resultJson.getJSONObject(CommonConstants.FEIGN_RESULT_DATA);
        } else {
            throw new EException(resultJson.getIntValue(CommonConstants.FEIGN_RESULT_CODE), resultJson.getString(CommonConstants.FEIGN_RESULT_MESSAGE));
        }
    }
}
