package com.esv.freight.notice.common.util;

import java.util.Random;

/**
 * @description: 短信验证码工具类
 * @project: notice-service
 * @name: com.esv.freight.notice.common.util.SmsCaptchaUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 16:51
 * @version:1.0
 */
public class SmsCaptchaUtils {

    /**
     * 短信验证码字符序列
     **/
    private static final char[] chars = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    /**
     * 短信验证码默认长度
     **/
    public static final int DEFAULT_SIZE = 6;

    /**
     * description 获取默认长度（6位）的短信验证码
     * param []
     * return java.lang.String
     * author Administrator
     * createTime 2020/04/15 16:56
     **/
    public static String getCaptcha() {
        return getCaptcha(DEFAULT_SIZE);
    }

    /**
     * description 获取指定长度的短信验证码
     * param [size]
     * return java.lang.String
     * author Administrator
     * createTime 2020/04/15 16:54
     **/
    public static String getCaptcha(int size) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < size; i++) {
            int n = new Random().nextInt(chars.length);
            stringBuffer.append(chars[n]);
        }
        return stringBuffer.toString();
    }

}
