package com.esv.freight.notice.module.msg.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 消息推送记录表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-06-09 11:06:04
 */
@Data
@TableName("base_notice_push_history")
public class NoticePushHistoryEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 设备类型：1-android、2-ios
	 */
	private Integer deviceType;
	/**
	 * 设备ID
	 */
	private String registrationId;
	/**
	 * 推送成功第三方返回的ID
	 */
	private String msgId;
	/**
	 * 推送序列号
	 */
	private Integer sendNo;
	/**
	 * 推送状态：-1-已推送、0-送达、1-未送达、2-registration_id 不属于该应用、3-registration_id 属于该应用，但不是该条 message 的推送目标、4-系统异常
	 */
	private Integer pushStatus;
	/**
	 * 推送内容
	 */
	private String pushContent;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
