package com.esv.freight.notice.module.msg.pojo;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-notice-service
 * @name: com.esv.freight.notice.module.msg.pojo.JPushObjectInfo
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/08 11:13
 * @version:1.0
 */
@Data
public class JPushObjectInfo {

    /**
     * APP类型：1-货主、2-司机
     */
    private Integer appType;

    /**
     * 设备类型：1-android、2-ios
     */
    private Integer deviceType;

    /**
     * 帐号
     */
    private String registrationId;

    /**
     * Json格式的消息内容
     */
    private JSONObject message;

    /**
     * 极光推送 appKey
     **/
    private String appKey;

    /**
     * 极光推送 appKey
     **/
    private String masterSecret;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
