package com.esv.freight.notice.module.sms.form;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description:
 * @project: notice-service
 * @name: com.esv.freight.notice.module.sms.form.CaptchaForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 17:58
 * @version:1.0
 */
@Data
public class CaptchaForm {

    @Length(min = 11, max = 11, message = "参数phone长度不合法")
    @NotBlank(message = "参数phone不能为空")
    private String phone;

    @Length(max = 16, message = "参数type长度不合法")
    @NotBlank(message = "参数type不能为空")
    private String type;

    @Length(min = 6, max = 6, message = "参数captcha长度不合法")
    private String captcha;

}
