package com.esv.superhive.iot.module.test.controller;

import com.alibaba.fastjson.JSONArray;
import com.esv.superhive.iot.common.component.RedisComponent;
import com.esv.superhive.iot.common.response.EResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @description:
 * @project: freight-base-service
 * @name: com.esv.htwl.base.module.test.controller.TestController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 14:00
 * @version:1.0
 */
@RestController
@RequestMapping("/test")
@Slf4j
public class TestController {

    @Autowired
    RedisComponent redisComponent;

    @GetMapping("/ping")
    public EResponse ping() {
        return EResponse.ok();
    }

    @GetMapping("/getCache")
    public EResponse getCache(HttpServletRequest request) {
        String key = request.getParameter("key");
        String str = (String) redisComponent.get(key);
        log.info(str);
        return EResponse.ok(str);
    }

    @GetMapping("/getCache4List")
    public EResponse getCache4List(HttpServletRequest request) {
        String key = request.getParameter("key");
        String str = (String) redisComponent.get(key);
        log.info(str);
        JSONArray array = JSONArray.parseArray(str);
        log.info(array.toJSONString());
        return EResponse.ok(array);
    }

}
