package com.esv.superhive.iot.module.devicemodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.superhive.iot.common.component.MqttAcl;
import com.esv.superhive.iot.common.component.MqttClientAuthComponent;
import com.esv.superhive.iot.module.datamodel.entity.DataModelEntity;
import com.esv.superhive.iot.module.devicemodel.dao.DeviceDataMapDao;
import com.esv.superhive.iot.module.devicemodel.dto.DeviceInstanceDto;
import com.esv.superhive.iot.module.devicemodel.entity.DeviceDataMapEntity;
import com.esv.superhive.iot.module.devicemodel.service.DeviceDataMapService;
import com.esv.superhive.iot.module.devicemodel.service.DeviceInstanceService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


@Service("deviceDataMapService")
public class DeviceDataMapServiceImpl extends ServiceImpl<DeviceDataMapDao, DeviceDataMapEntity> implements DeviceDataMapService {

    @Autowired
    MqttClientAuthComponent mqttClientAuthComponent;

    @Autowired
    DeviceInstanceService deviceInstanceService;

    @Override
    public int getCountByDataModelId(Long dataModelId) {
        return this.getBaseMapper().selectCount(new LambdaQueryWrapper<DeviceDataMapEntity>()
                .eq(DeviceDataMapEntity::getDataModelId, dataModelId));
    }

    @Override
    public void deleteByDeviceTypeId(Long deviceTypeId) {
        this.getBaseMapper().delete(new LambdaQueryWrapper<DeviceDataMapEntity>()
                .eq(DeviceDataMapEntity::getDeviceTypeId, deviceTypeId));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDeviceDataMap(Long deviceTypeId, String dataModelIds) {
        this.getBaseMapper().delete(new LambdaQueryWrapper<DeviceDataMapEntity>().eq(DeviceDataMapEntity::getDeviceTypeId, deviceTypeId));

        String[] dataModelIdList = null;
        if (Objects.nonNull(StringUtils.trimToNull(dataModelIds))) {
            dataModelIdList = dataModelIds.split(",");
            for (String dataModelId : dataModelIdList) {
                DeviceDataMapEntity entity = new DeviceDataMapEntity();
                entity.setDeviceTypeId(deviceTypeId);
                entity.setDataModelId(Long.parseLong(dataModelId));
                this.getBaseMapper().insert(entity);
            }
        }

        // 更新设备实例的Mqtt Topic权限
        DeviceInstanceDto deviceInstanceDto = new DeviceInstanceDto();
        deviceInstanceDto.setDeviceTypeId(deviceTypeId);
        List<DeviceInstanceDto> dtoList = deviceInstanceService.get4List(deviceInstanceDto);
        String communicationId;
        Long deviceInstanceId;
        for (DeviceInstanceDto dto : dtoList) {
            communicationId = dto.getCommunicationId();
            mqttClientAuthComponent.deleteClientAcl(communicationId);

            deviceInstanceId = dto.getId();
            if (Objects.nonNull(dataModelIdList)) {
                List<MqttAcl> mqttAclList = new ArrayList<>();
                for (String dataModelId : dataModelIdList) {
                    MqttAcl mqttAcl = new MqttAcl();
                    mqttAcl.setAllow(1);
                    mqttAcl.setClientid(communicationId);
                    mqttAcl.setAccess(2);
                    StringBuffer sb = new StringBuffer();
                    sb.append("$esv/iot/")
                            .append(dataModelId).append("/")
                            .append(deviceTypeId).append("/")
                            .append(deviceInstanceId).append("/data/upload");
                    mqttAcl.setTopic(sb.toString());
                    mqttAclList.add(mqttAcl);
                }
                mqttClientAuthComponent.saveClientAcl(mqttAclList);
            }
        }
    }

    @Override
    public List<DataModelEntity> getDataModelByDeviceTypeId(Long deviceTypeId) {
        DeviceDataMapEntity entity = new DeviceDataMapEntity();
        entity.setDeviceTypeId(deviceTypeId);
        return this.getBaseMapper().selectDataModelByDeviceTypeId(entity);
    }

}