package com.esv.superhive.iot.module.devicemodel.form;

import com.esv.superhive.iot.common.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/06 16:34
 * @version:1.0
 */
@Data
public class DeviceTypeForm {

    /**
     *
     */
    @NotNull(message = "[设备类型ID]不能为空", groups = {ValidatorUpdate.class, ValidatorDelete.class, ValidatorDetail.class})
    private Long id;
    /**
     * 名称
     */
    @Length(max = 50, message = "[设备类型名称]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    @NotBlank(message = "[设备类型名称]不能为空", groups = {ValidatorInsert.class})
    private String name;
    /**
     * 描述
     */
    @Length(max = 200, message = "[设备类型描述]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "[设备类型描述]不能为空", groups = {ValidatorInsert.class})
    private String description;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
