package com.esv.superhive.iot.module.devicemodel.form;

import com.esv.superhive.iot.common.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/07 10:21
 * @version:1.0
 */
@Data
public class DeviceInstanceForm {

    /**
     *
     */
    @NotNull(message = "[设备ID]不能为空", groups = {ValidatorDelete.class, ValidatorUpdate.class, ValidatorDetail.class})
    private Long id;
    /**
     * 设备类型ID
     */
    @NotNull(message = "[设备类型ID]不能为空", groups = {ValidatorInsert.class, ValidatorListById.class})
    private Long deviceTypeId;
    /**
     * 设备名称
     */
    @Length(max = 50, message = "[设备名称]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    @NotBlank(message = "[设备名称]不能为空", groups = {ValidatorInsert.class})
    private String name;
    /**
     * 设备描述
     */
    @Length(max = 200, message = "[设备描述]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "[设备描述]不能为空", groups = {ValidatorInsert.class})
    private String description;
    /**
     * 设备业务ID
     */
    @Length(max = 50, message = "[设备业务ID]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    private String businessId;
    /**
     * 设备型号
     */
    @Length(max = 200, message = "[设备型号]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    private String deviceModel;
    /**
     * 在线状态
     */
    private Integer onlineState;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
