package com.esv.superhive.iot.module.devicemodel.form;

import com.esv.superhive.iot.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/07 14:40
 * @version:1.0
 */
@Data
public class DeviceDataMapForm {

    /**
     * 设备类型ID
     */
    @NotNull(message = "[设备类型ID]不能为空", groups = {ValidatorInsert.class})
    private Long deviceTypeId;
    /**
     * 数据模型ID
     */
    private String dataModelId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
