package com.esv.superhive.iot.module.devicemodel.dao;

import com.esv.superhive.iot.module.datamodel.entity.DataModelEntity;
import com.esv.superhive.iot.module.devicemodel.entity.DeviceDataMapEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 设备类型-数据模型映射表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
@Mapper
public interface DeviceDataMapDao extends BaseMapper<DeviceDataMapEntity> {

    /**
     * @description 通过设备类型ID获取对应的数据模型列表
     * @param entity:
     * @return java.util.List<com.esv.superhive.iot.module.datamodel.entity.DataModelEntity>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 14:31
     **/
    List<DataModelEntity> selectDataModelByDeviceTypeId(DeviceDataMapEntity entity);
	
}
