package com.esv.superhive.iot.module.dashboard.service;

import com.esv.superhive.iot.module.dashboard.dto.DataPreviewDTO;
import com.esv.superhive.iot.module.dashboard.req.DashboardReq;
import com.esv.superhive.iot.module.dashboard.req.HistoryDashboardReq;
import com.esv.superhive.iot.module.dashboard.req.TimeDomainReq;
import com.esv.superhive.iot.module.dashboard.vo.FrequencyDomainVO;
import com.esv.superhive.iot.module.dashboard.vo.ModelDataVO;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: superhive-iot-service
 * @name: com.esv.superhive.iot.module.dashboard.service.DashboardService
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/3 20:23
 * @version: 1.0
 */
public interface DashboardService {

    /**
     * description 查询模型数据
     * param [dashboardReqList]
     * return java.util.List<com.esv.superhive.iot.module.dashboard.vo.ModelDataVO>
     * author chenfm
     * createTime 2020/8/20 15:13
     **/
    List<ModelDataVO> modelData(List<DashboardReq> dashboardReqList);

    /**
     * description 查询模型历史数据
     * param [historyDashboardReq]
     * return java.util.List<com.esv.superhive.iot.module.dashboard.vo.ModelDataVO>
     * author chenfm
     * createTime 2020/8/20 15:13
     **/
    List<ModelDataVO> modelHistory(HistoryDashboardReq historyDashboardReq);

    /**
     * description 时域数据
     * param [timeDomainReq]
     * return com.esv.superhive.iot.module.dashboard.vo.ModelDataVO
     * author chenfm
     * createTime 2020/8/20 15:13
     **/
    Map<String, Object> timeDomainData(TimeDomainReq timeDomainReq);

    FrequencyDomainVO processFrequencyDomain(List<String> resultList);

    List<DataPreviewDTO> dataPreview(long modelId, long deviceId);

}
