package com.esv.superhive.iot.module.dashboard.controller;

import com.esv.superhive.iot.common.response.EResponse;
import com.esv.superhive.iot.module.dashboard.dto.DataPreviewDTO;
import com.esv.superhive.iot.module.dashboard.req.DashboardReq;
import com.esv.superhive.iot.module.dashboard.req.FrequencyDomainReq;
import com.esv.superhive.iot.module.dashboard.req.HistoryDashboardReq;
import com.esv.superhive.iot.module.dashboard.req.TimeDomainReq;
import com.esv.superhive.iot.module.dashboard.service.DashboardService;
import com.esv.superhive.iot.module.dashboard.service.PythonService;
import com.esv.superhive.iot.module.dashboard.vo.FrequencyDomainVO;
import com.esv.superhive.iot.module.dashboard.vo.ModelDataVO;
import lombok.extern.slf4j.Slf4j;
import org.postgresql.jdbc.PgArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: superhive-iot-service
 * @name: com.esv.superhive.iot.module.dashboard.controller.DashboardController
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/7/31 17:53
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("dashboard")
public class DashboardController {

    private DashboardService dashboardService;

    private PythonService pythonService;

    @Autowired
    public DashboardController(DashboardService dashboardService, PythonService pythonService) {
        this.dashboardService = dashboardService;
        this.pythonService = pythonService;
    }

    /**
     * description 查询模型数据
     * param [dashboardReqList]
     * return com.esv.superhive.iot.common.response.EResponse<java.util.List<com.esv.superhive.iot.module.dashboard.vo.ModelDataVO>>
     * author chenfm
     * createTime 2020/8/20 14:54
     **/
    @PostMapping("modelData")
    public EResponse<List<ModelDataVO>> modelData(@RequestBody List<DashboardReq> dashboardReqList) {
        List<ModelDataVO> list = dashboardService.modelData(dashboardReqList);
        return EResponse.ok(list);
    }

    /**
     * description 查询模型历史数据
     * param [historyDashboardReq]
     * return com.esv.superhive.iot.common.response.EResponse<java.util.List<com.esv.superhive.iot.module.dashboard.vo.ModelDataVO>>
     * author chenfm
     * createTime 2020/8/20 14:55
     **/
    @PostMapping("modelHistory")
    public EResponse<List<ModelDataVO>> modelHistory(@RequestBody @Validated HistoryDashboardReq historyDashboardReq) {
        List<ModelDataVO> list = dashboardService.modelHistory(historyDashboardReq);
        return EResponse.ok(list);
    }

    @PostMapping("dataPreview")
    public EResponse<List<DataPreviewDTO>> dataPreview(@RequestBody TimeDomainReq timeDomainReq) {
        long modelId = timeDomainReq.getModelId();
        long deviceId = timeDomainReq.getDeviceId();
        List<DataPreviewDTO> list = dashboardService.dataPreview(modelId, deviceId);
        return EResponse.ok(list);
    }


    /**
     * description 时域数据
     * param []
     * return com.esv.superhive.iot.common.response.EResponse<com.esv.superhive.iot.module.dashboard.vo.ModelDataVO>
     * author chenfm
     * createTime 2020/8/20 14:57
     **/
    @PostMapping("timeDomainData")
    public EResponse<Map<String, Object>> timeDomainData(@RequestBody @Validated TimeDomainReq timeDomainReq) {
        Map<String, Object> data = dashboardService.timeDomainData(timeDomainReq);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getValue() instanceof PgArray) {
                PgArray pgArray = (PgArray) entry.getValue();
                log.info("pgArray: {}", pgArray);
                try {
                    data.put(entry.getKey(), pgArray.getArray());
                } catch (SQLException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return EResponse.ok(data);
    }

    @PostMapping("frequencyDomainData")
    public EResponse frequencyDomainData(@RequestBody @Validated FrequencyDomainReq frequencyDomainReq) {
        List<String> resultList = pythonService.calcFrequency(frequencyDomainReq);

        // 振幅, 频率, 位移
        FrequencyDomainVO frequencyDomainVO = dashboardService.processFrequencyDomain(resultList);
        return EResponse.ok(frequencyDomainVO);
    }

}
