package com.esv.superhive.iot.module.alarm.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.superhive.iot.common.vo.PageResultVO;
import com.esv.superhive.iot.module.alarm.dao.DeviceDataAlarmDao;
import com.esv.superhive.iot.module.alarm.dto.DeviceDataAlarmDTO;
import com.esv.superhive.iot.module.alarm.entity.DeviceDataAlarmEntity;
import com.esv.superhive.iot.module.alarm.form.AlarmListForm;
import com.esv.superhive.iot.module.alarm.service.DeviceDataAlarmService;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @project: superhive-iot-service
 * @name: com.esv.superhive.iot.module.alarm.service.impl.DeviceDataAlarmServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/7 14:17
 * @version: 1.0
 */
@Service("deviceDataAlarmService")
public class DeviceDataAlarmServiceImpl extends ServiceImpl<DeviceDataAlarmDao, DeviceDataAlarmEntity> implements DeviceDataAlarmService {

    @Override
    public PageResultVO alarmList(AlarmListForm alarmListForm) {
        IPage<DeviceDataAlarmDTO> page = new Page<>(alarmListForm.getPageNum(), alarmListForm.getPageSize());
        page = baseMapper.alarmList(page, alarmListForm);
        return new PageResultVO(page, page.getRecords());
    }

    @Override
    public DeviceDataAlarmDTO alarmDetail(Long id) {
        return baseMapper.alarmDetail(id);
    }
}
