package com.esv.superhive.iot.config.mybatis;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.esv.superhive.iot.common.util.ReqUtils;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @description:
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 13:31
 * @version:1.0
 */
@Slf4j
@Component
public class EsvMetaObjectHandler implements MetaObjectHandler {

    @Override
    public void insertFill(MetaObject metaObject) {
        if (metaObject.hasSetter("createUser")) {
            String userAccount = ReqUtils.getRequestHeader(GatewayHeaders.USER_ACCOUNT);
            this.setFieldValByName("createUser", userAccount, metaObject);
        }
        if (metaObject.hasSetter("createTime")) {
            this.setFieldValByName("createTime", new Date(), metaObject);
        }
        if (metaObject.hasSetter("updateUser")) {
            String userAccount = ReqUtils.getRequestHeader(GatewayHeaders.USER_ACCOUNT);
            this.setFieldValByName("updateUser", userAccount, metaObject);
        }
        if (metaObject.hasSetter("updateTime")) {
            this.setFieldValByName("updateTime", new Date(), metaObject);
        }
        if (metaObject.hasSetter("tenantId") && metaObject.getValue("tenantId") == null) {
            String tenantId = ReqUtils.getRequestHeader(GatewayHeaders.TENANT_ID);
            this.setFieldValByName("tenantId", Long.parseLong(tenantId), metaObject);
        }
        if (metaObject.hasSetter("departmentId") && metaObject.getValue("departmentId") == null) {
            String departmentId = ReqUtils.getRequestHeader(GatewayHeaders.DEPARTMENT_ID);
            if (StringUtils.isBlank(departmentId)) {
                departmentId = "-1";
            }
            this.setFieldValByName("departmentId", Long.parseLong(departmentId), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        if (metaObject.hasSetter("updateUser")) {
            String userAccount = ReqUtils.getRequestHeader(GatewayHeaders.USER_ACCOUNT);
            this.setFieldValByName("updateUser", userAccount, metaObject);
        }
        if (metaObject.hasSetter("updateTime")) {
            this.setFieldValByName("updateTime", new Date(), metaObject);
        }
    }
}
