package com.esv.superhive.iot.common.util;

import lombok.extern.slf4j.Slf4j;

import java.io.*;

@Slf4j
public class FileUtils {

    public static String readFileContent(String fileName) {
        String fileContent = null;
        FileInputStream fip = null;
        InputStreamReader reader = null;
        try {
            File f = new File(fileName);
            fip = new FileInputStream(f);
            reader = new InputStreamReader(fip, "UTF-8");
            StringBuffer sb = new StringBuffer();
            while (reader.ready()) {
                sb.append((char) reader.read());
            }
            fileContent = sb.toString();
        } catch (IOException e) {
            log.error(e.getMessage());
        } finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != fip) {
                    fip.close();
                }
            } catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        return fileContent;
    }

    public static String getJarFileContent(Class<?> c, String dataPath) throws Exception {
        InputStream inputStream = c.getResourceAsStream(dataPath);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuffer sb = new StringBuffer();
        String txt;
        while ((txt = bufferedReader.readLine()) != null) {
            sb.append(txt);
        }
        return sb.toString();
    }

}
