package com.esv.superhive.iot.common.component;

import com.esv.superhive.iot.common.util.FileUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/03 20:09
 * @version:1.0
 */
@Component
@RefreshScope
@Slf4j
public class BaseDataComponent {

    @Value("${db.dict.table-field.map}")
    private String dbTableFieldMap;

    private static Map<String, Boolean> sqlReservedWordsMap;

    /**
     * @description 获取数据库表字段映射
     * @return java.util.Map<java.lang.Integer,java.lang.String>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 20:12
     **/
    public Map<Integer, String> getDbTableFieldMap() {
        Map<Integer, String> map = new HashMap<>(32);
        String[] kvs = dbTableFieldMap.split(",");
        for (String kv : kvs) {
            map.put(Integer.parseInt(kv.split("-")[0]), kv.split("-")[1]);
        }
        return map;
    }

    /**
     * @description 获取SQL保留字
     * @return java.util.Map<java.lang.String,java.lang.Boolean>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/04 9:13
     **/
    public Map<String, Boolean> getSqlReservedWordsMap() {
        if (null != sqlReservedWordsMap) {
            return sqlReservedWordsMap;
        }
        sqlReservedWordsMap = new HashMap<>(1024);
        String dataPath = "/data/SqlReservedWords.txt";
        try {
            String fileContent = FileUtils.getJarFileContent(this.getClass(), dataPath);
            String[] words = fileContent.split(",");
            for (int i = 0; i < words.length; i++) {
                sqlReservedWordsMap.put(words[i], true);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return sqlReservedWordsMap;
    }

}
