package com.esv.datacenter.iot.module.datamodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelEntity;
import com.esv.datacenter.iot.module.datamodel.form.DataModelForm;
import com.esv.datacenter.iot.module.datamodel.vo.DataDataModelDetailVO;
import com.esv.datacenter.iot.module.datamodel.vo.DataModelVO;

import java.util.List;

/**
 * 数据物模型Service
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
public interface DataModelService extends IService<DataModelEntity> {

    /**
     * @description 创建模型
     * @param form:
     * @return java.lang.Long
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 13:52
     **/
    Long createObjectModel(DataModelForm form);

    /**
     * @description 分页查询模型列表
     * @param queryObj:
     * @return com.esv.datacenter.iot.common.vo.PageResultVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 16:26
     **/
    PageResultVO getModel4Page(DataModelForm queryObj);

    /**
     * @description 获取模型详情
     * @param form:
     * @return com.esv.datacenter.iot.module.dmodel.vo.ModelDetailVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 10:25
     **/
    DataDataModelDetailVO getModelDetail(DataModelForm form);
    
    /**
     * @description 更新模型
     * @param form: 
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 10:48
     **/
    void updateModel(DataModelForm form);

    /**
     * @description 删除模型
     * @param modelId:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 11:33
     **/
    void deleteModel(Long modelId);

    /**
     * @description 获取所有模型列表
     * @return java.util.List<com.esv.datacenter.iot.module.dmodel.vo.ModelVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 13:04
     **/
    List<DataModelVO> getAllModeList();

    /**
     * @description 判断模型是否存在
     * @param modelId:
     * @return java.lang.Boolean
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:19
     **/
    Boolean isModelExits(Long modelId);

    /**
     * @description 获取模型信息
     * @param id:
     * @return com.esv.datacenter.iot.module.dmodel.entity.ObjectModelEntity
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 13:39
     **/
    DataModelEntity getModelInfo(Long id);

}

