package com.esv.datacenter.iot.common.component;

import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/13 15:36
 * @version:1.0
 */
@Component
@RefreshScope
@Slf4j
public class MqttClientAuthComponent {

    @Value("${emq.data-source.jdbc-url}")
    private String jdbcUrl;

    @Value("${emq.data-source.driver-class-name}")
    private String driverClassName;

    @Value("${emq.data-source.validation-query}")
    private String validationQuery;

    @Value("${emq.data-source.username}")
    private String username;

    @Value("${emq.data-source.password}")
    private String password;

    @Value("${emq.data-source.connection-timeout}")
    private Long connectionTimeout;

    @Value("${emq.data-source.minimum-idle}")
    private Integer minimumIdle;

    @Value("${emq.data-source.maximum-pool-size}")
    private Integer maximumPoolSize;

    @Value("${emq.data-source.max-lifetime}")
    private Long maxLifetime;

    @Value("${emq.client-auth.table-name}")
    private String tableName;

    @Value("${emq.client-auth.username}")
    private String clientAuthUserName;

    @Autowired
    private DynamicDataSource dynamicDataSource;

    /**
     * @description 保存client Topic发布/订阅权限
     * @param mqttAclList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/13 16:06
     **/
    public void saveClientAcl(List<MqttAcl> mqttAclList) {
        HikariDataSource dataSource = this.getHikariDataSource4Transaction();

        String clientId = mqttAclList.get(0).getClientId();
        try {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            // 删除clientId原有记录
            StringBuffer sb = new StringBuffer();
            sb.append("delete from ").append(tableName).append(" where clientid='").append(clientId).append("';");
            String deleteSql = sb.toString();
            log.info("删除clientId原有记录SQL：{}", deleteSql);
            jdbcTemplate.execute(deleteSql);

            // 新增clientId记录
            for (MqttAcl mqttAcl : mqttAclList) {
                sb = new StringBuffer();
                sb.append("INSERT INTO ").append(tableName)
                        .append("(allow, username, clientid, access, topic) VALUES(")
                        .append(mqttAcl.getAllow())
                        .append(",'").append(clientAuthUserName).append("'")
                        .append(",'").append(mqttAcl.getClientId()).append("'")
                        .append(",").append(mqttAcl.getAccess())
                        .append(",'").append(mqttAcl.getTopic()).append("'")
                        .append(");");
                String insertSql = sb.toString();
                log.info("新增clientId记录SQL：{}", insertSql);
                jdbcTemplate.execute(insertSql);
            }
        } catch (Exception e) {
            log.error("保存[clientId={}]Topic发布/订阅权限失败", clientId);
            log.error(e.getMessage(), e);
            throw e;
        } finally {
            // 关闭数据源
            if (Objects.nonNull(dataSource) && !dataSource.isClosed()) {
                dataSource.close();
            }
        }
    }

    /**
     * @description 删除clientId记录
     * @param clientId:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/13 16:54
     **/
    public void deleteClientAcl(String clientId) {
        HikariDataSource dataSource = this.getHikariDataSource4Transaction();

        try {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            // 删除clientId原有记录
            StringBuffer sb = new StringBuffer();
            sb.append("delete from ").append(tableName).append(" where clientid='").append(clientId).append("';");
            String deleteSql = sb.toString();
            log.info("删除clientId记录SQL：{}", deleteSql);
            jdbcTemplate.execute(deleteSql);
        } catch (Exception e) {
            log.error("删除[clientId={}]Topic发布/订阅权限失败", clientId);
            log.error(e.getMessage(), e);
            throw e;
        } finally {
            // 关闭数据源
            if (Objects.nonNull(dataSource) && !dataSource.isClosed()) {
                dataSource.close();
            }
        }
    }

    private HikariDataSource getHikariDataSource4Transaction() {
        HikariDataSource dataSource = this.dynamicDataSource.getDynamicDataSource4Transaction(initDataSourceConfig());
        return dataSource;
    }

    private DataSourceConfig initDataSourceConfig() {
        DataSourceConfig dataSourceConfig = new DataSourceConfig(jdbcUrl, driverClassName, username, password,
                validationQuery, connectionTimeout, minimumIdle, maximumPoolSize, maxLifetime);
        return dataSourceConfig;
    }
}
