package com.esv.datacenter.iot.module.devicemodel.controller;

import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.common.response.EResponse;
import com.esv.datacenter.iot.module.devicemodel.form.DeviceDataForm;
import com.esv.datacenter.iot.module.devicemodel.service.DeviceDataService;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.devicemodel.controller.DeviceDataController
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/13 16:47
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("/deviceModel/data")
@Validated
public class DeviceDataController {

    private DeviceDataService deviceDataService;

    @Autowired
    public DeviceDataController(DeviceDataService deviceDataService) {
        this.deviceDataService = deviceDataService;
    }

    @PostMapping("getDataByModel")
    public EResponse<DeviceDataVO> currentData(@RequestBody @Validated DeviceDataForm deviceDataForm) {
        DeviceDataVO deviceDataVO = deviceDataService.currentData(deviceDataForm.getDeviceId(), deviceDataForm.getDataModelId());
        if (deviceDataVO == null) {
            return EResponse.error(ECode.NO_DATA);
        }
        return EResponse.ok(deviceDataVO);
    }


}
